
clear
set obs 100
g dif=0.0775+(_n/400)
scalar zalfa= invnormal(1-(0.05/ 2 ))
g p = 0.2
g zbeta1 = ((100*((dif)^2) / (2*p*(1-p)) )^0.5) - zalfa 
g zbeta2 = ((50*((dif)^2) / (2*p*(1-p)) )^0.5) - zalfa 
g potencia1 = normal(zbeta1)
lab var potencia1 "n cada grupo=100"
g potencia2 = normal(zbeta2)
lab var potencia2 "n cada grupo=50"
twoway (line potencia1 dif,lcolor(red) lwidth(medthick)) ///
(line potencia2 dif,lc(black) lw(medthick) lpattern(dash)), ///
title("Potencia segn diferencia esperada") ///
subtitle("(alfa/2=0.025 y % de eventos=20%)") ///
ytitle(Potencia) xtitle("Diferencia (pA-pB) entre grupos") ///
xlabel(0.1(0.05)0.3, grid) ylabel(0(0.1)1, grid)


